import sys, os

os.environ["OMP_NUM_THREADS"] = "1"


from torch import multiprocessing
from torch.utils.tensorboard.writer import SummaryWriter
from continual_rl.utils.argparse_manager import ArgparseManager, ArgparseManager2

# import os
# os.environ["OMP_NUM_THREADS"] = "1"


if __name__ == "__main__":
    # Pytorch multiprocessing requires either forkserver or spawn.
    # 设置 OMP_NUM_THREADS 为 1
    # os.environ["OMP_NUM_THREADS"] = "1"

    try:
        # os.environ["OMP_NUM_THREADS"] = "1"
        multiprocessing.set_start_method("spawn")
    except ValueError as e:
        # Windows doesn't support forking, so fall back to spawn instead
        assert "cannot find context" in str(e)
        multiprocessing.set_start_method("spawn")


        

    # experiment, policy = ArgparseManager.parse(sys.argv[1:])
    manager = ArgparseManager2()
    experiment, policy, r_experiment = manager.run()
    print(experiment)
    print(policy)

    if experiment is None:
        raise RuntimeError("No experiment started. Most likely there is no new run to start.")

    summary_writer = SummaryWriter(log_dir=experiment.output_dir)
    experiment.try_run(policy, summary_writer=summary_writer)
